<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

class MageQL_Catalog_Model_Product_Bundle_Selection {
    /**
     * @var MageQL_Catalog_Model_Product_Bundle_Option
     */
    protected $option;

    /**
     * @var Mage_Catalog_Model_Product
     */
    protected $product;

    public function __construct(
        MageQL_Catalog_Model_Product_Bundle_Option $option,
        Mage_Catalog_Model_Product $product
    ) {
        $this->option = $option;
        $this->product = $product;
    }

    public function getProduct(): Mage_Catalog_Model_Product {
        return $this->product;
    }

    public function getSelectionId(): string {
        // A bit retarded, but the selection is MERGED with the product
        return $this->product->getSelectionId();
    }

    public function getIsDefault(): bool {
        return (bool)$this->product->getIsDefault();
    }

    public function getQty(): float {
        return (float)$this->product->getSelectionQty();
    }

    public function getIsQtyFixed(): bool {
        return !$this->product->getSelectionCanChangeQty();
    }

    public function getPrice(): MageQL_Catalog_Model_Product_Price {
        $price = 0.0;
        $product = $this->option->getProduct();

        switch($product->getPriceType()) {
        case 1: // Fixed parent price, selections specify price in either value or percent
            switch($this->product->getSelectionPriceType()) {
            case 0: // Fixed
                $price = $this->product->getSelectionPriceValue();
                break;

            case 1: // Percent
                $price = $product->getFinalPrice() * ($this->product->getSelectionPriceValue() / 100);
                break;
            }
            break;

        case 0: // Dynamic parent price, use the price of the children
            $price = $this->product->getFinalPrice();
            break;
        }

        return new MageQL_Catalog_Model_Product_Price($product, $price);
    }
}
