<?php

declare(strict_types=1);

/**
 * @psalm-type AttrData array{
 *   code:string,
 *   backend_type:string,
 *   input:string,
 *   label:string,
 *   required:bool,
 *   not_system:bool,
 *   attribute_set:Array<string>,
 *   attribute_set_type:Array<string>,
 *   apply_to:Array<string>,
 *   show_in_detail:bool,
 *   show_in_list:bool,
 *   filterable:bool
 * }
 * @template-extends MageQL_Catalog_Model_Attributes_Abstract<Mage_Catalog_Model_Category, AttrData>
 */
class MageQL_Catalog_Model_Attributes_Category extends MageQL_Catalog_Model_Attributes_Abstract {
    protected function getEntityType(): string {
        return "catalog_category";
    }

    public function getBaseAttributes(): array {
        return [
            "children_count",
            "entity_id",
            "is_active",
            "is_anchor",
            "level",
            "path",
        ];
    }

    public function getFieldAttributeMap(): array {
        return [
            "url" => ["url_key", "url_path"],
        ];
    }

    protected function filterAttributeData(array $a): array {
        $a = parent::filterAttributeData($a);

        // Categories do not have any special types
        $a["apply_to"] = [];

        return $a;
    }

    /**
     * @param Mage_Catalog_Model_Category $src
     * @param array{width?:int, height?:int, fill?:bool} $args
     */
    public function resizeImage($src, string $attr, string $image, array $args): string {
        $resize = array_key_exists("height", $args) || array_key_exists("width", $args);
        $model = Mage::getModel("mageql_catalog/category_image");

        if($resize) {
            // We need to set this before setBaseFile since that will set the
            // filename for the resized file
            $model->setWidth($args["width"] ?? null)
                  ->setHeight($args["height"] ?? null);
        }

        $model->setKeepFrame($args["fill"] ?? false);
        $model->setBaseFile($image);

        if($model->isCached()) {
            return $model->getUrl();
        }

        if($resize) {
            $model->resize();
        }

        return $model->saveFile()->getUrl();
    }
}
