<?php

class MageQL_Catalog_Helper_Data extends Mage_Core_Helper_Abstract {
    /**
     * Returns true if the supplied product is visible on its own in the
     * given store.
     */
    public function isProductVisible(
        Mage_Catalog_Model_Product $product,
        Mage_Core_Model_Store $store
    ): bool {
        return $product->getId() &&
            ! $product->isDisabled() &&
            $product->isVisibleInSiteVisibility() &&
            in_array($store->getWebsiteId(), $product->getWebsiteIds());
    }
}
