<?php

/**
 * @psalm-scope-this Mage_Core_Model_Resource_Setup
 * @var Mage_Core_Model_Resource_Setup
 */
$installer = $this;

$installer->setConfigData(Mage_Catalog_Helper_Product_Flat::XML_PATH_USE_PRODUCT_FLAT, "1");
$installer->setConfigData(Mage_Catalog_Helper_Category_Flat::XML_PATH_IS_ENABLED_FLAT_CATALOG_CATEGORY, "1");

$detail = [ "is_visible_on_front" => true ];
$both = [ "used_in_product_listing" => true, "is_visible_on_front" => true ];

$config = [
    "catalog_product" => [
        "description" => $detail,
        "meta_description" => $detail,
        "meta_keyword" => $detail,
        "meta_title" => $detail,
        "minimal_price" => $both,
        "msrp" => $both,
        "msrp_enabled" => $both,
        "name" => $both,
        "short_description" => $both,
        "small_image" => $both,
        "small_image_label" => $both,
        "thumbnail" => $both,
    ],
    "catalog_category" => [
        "description" => $both,
        "image" => $both,
        "meta_description" => $both,
        "meta_keywords" => $both,
        "meta_title" => $both,
        "name" => $both,
    ],
];

foreach($config as $entity => $attrs) {
    foreach($attrs as $a => $props) {
        $model = Mage::getSingleton("eav/config");

        $attr = $model->getAttribute($entity, $a);

        if($attr) {
            $attr->addData($props)
                ->save();
        }
    }
}
