<?php

declare(strict_types=1);

class MageQL_Catalog_Model_Product_Price {
    protected $product;
    protected $price;

    public function __construct(Mage_Catalog_Model_Product $product, $price) {
        $this->product = $product;
        $this->price = $price;
    }

    /**
     * Takes a tuple of product and calculated price and returns the price including tax.
     */
    public function getIncVat() {
        return Mage::helper("tax")->getPrice($this->product, $this->price, true);
    }

    /**
     * Takes a tuple of product and calculated price and returns the price excluding tax.
     */
    public function getExVat() {
        return Mage::helper("tax")->getPrice($this->product, $this->price, false);
    }

    /**
     * Takes a tuple of product and calculated price and returns tax amount.
     */
    public function getVat(Mage_Core_Model_Store $store) {
        $helper = Mage::helper("tax");

        if($helper->priceIncludesTax()) {
            return max(0, $store->roundPrice($this->price - $helper->getPrice($this->product, $this->price, false)));
        }
        else {
            return max(0, $store->roundPrice($helper->getPrice($this->product, $this->price, true) - $this->price));
        }
    }
}
