<?php

class MageQL_Catalog_Model_Category_Image extends Mage_Catalog_Model_Product_Image {
    public function getCategoryMediaBasePath() {
        return Mage::getBaseDir("media") . DS."catalog".DS."category".DS;
    }

    public function getCategoryMediaCache() {
        return Mage::getBaseDir("media") . DS."catalog".DS."category_cache";
    }

    public function setBaseFile($file) {
        $this->_isBaseFilePlaceholder = false;

        if (($file) && (0 !== strpos($file, '/', 0))) {
            $file = '/' . $file;
        }
        $baseDir = $this->getCategoryMediaBasePath();

        if ($file) {
            if ((!$this->_fileExists($baseDir . $file)) || !$this->_checkMemory($baseDir . $file)) {
                $file = null;
            }
        }

        $baseFile = $baseDir . $file;

        $this->_baseFile = $baseFile;

        // build new filename (most important params)
        $path = array_filter([
            $this->getCategoryMediaCache(),
            Mage::app()->getStore()->getId(),
            $this->getDestinationSubdir()
        ]);
        if((!empty($this->_width)) || (!empty($this->_height)))
            $path[] = "{$this->_width}x{$this->_height}";

        // add misk params as a hash
        $miscParams = [
                ($this->_keepAspectRatio  ? '' : 'non') . 'proportional',
                ($this->_keepFrame        ? '' : 'no')  . 'frame',
                ($this->_keepTransparency ? '' : 'no')  . 'transparency',
                ($this->_constrainOnly ? 'do' : 'not')  . 'constrainonly',
                $this->_rgbToString($this->_backgroundColor),
                'angle' . $this->_angle,
                'quality' . $this->_quality
        ];

        $path[] = md5(implode('_', $miscParams));

        // append prepared filename
        $this->_newFile = implode('/', $path) . $file; // the $file contains heading slash

        return $this;
    }

    protected function _getWatermarkFilePath()
    {
        return false;
    }

    public function clearCache() {
        $directory = $this->getCategoryMediaCache();

        $io = new Varien_Io_File();
        $io->rmdir($directory, true);

        Mage::helper('core/file_storage_database')->deleteFolder($directory);
    }
}
