<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

class MageQL_Catalog_Model_Category extends Mage_Core_Model_Abstract {
    public static function resolveRoot($src, array $args, $ctx) {
        $category = Mage::getModel("catalog/category");

        $category->load($ctx->getStore()->getRootCategoryId());

        if( ! $category->getId() || ! $category->getIsActive()) {
            throw new Exception("Could not find root category");
        }

        return $category;
    }

    public static function resolveNavItems($src, array $args, $ctx, ResolveInfo $info) {
        $fakeRoot = new Varien_Object([
            "id" => $ctx->getStore()->getRootCategoryId(),
            // We are faking this, make sure we do not use it as the actual count
            // in resolveChildren
            "children_count" => 1,
        ]);

        return self::resolveChildren($fakeRoot, $args, $ctx, $info);
    }

    public static function resolveByRoute($rewrite) {
        $category = Mage::getModel("catalog/category");

        $category->load($rewrite->getCategoryId());

        if($category->getId() && $category->getIsActive()) {
            return $category;
        }

        return null;
    }

    public static function resolveChildren($src, array $args, $ctx, ResolveInfo $info) {
        if($src->getChildrenCount() < 1) {
            // Optimization, no need to query if we do not have any children
            return [];
        }

        $catAttrs = Mage::getSingleton("mageql_catalog/attributes_category");
        $categories = Mage::getModel("catalog/category")->getCollection();

        $toSelect = $catAttrs->getUsedAttributes(
            $catAttrs->getAttributesByArea(MageQL_Catalog_Model_Attributes_Abstract::AREA_ANY),
            $info->getFieldSelection(1)
        );

        foreach($toSelect as $col) {
            $categories->addAttributeToSelect($col);
        }

        $categories->addAttributeToFilter("is_active", "1");
        $categories->addAttributeToFilter("include_in_menu", "1");

        $categories->addAttributeToFilter("parent_id", $src->getId());

        $categories->addAttributeToSort("position", "asc");
        $categories->addAttributeToSort("name", "asc");

        return $categories->getItems();
    }

    public static function resolveProducts($category, array $args, $ctx, ResolveInfo $info) {
        $collection = Mage::getModel("catalog/product")->getCollection();

        // We do not yet select any attributes, that is done when we
        // fetch the data in the items resolver
        $collection->addCategoryFilter($category);
        $collection->addUrlRewrite($category->getId());
        $collection->addAttributeToSort("position", "asc");

        return MageQL_Catalog_Model_Product::preparePaginatedProductCollection(
            $collection,
            $args,
            $ctx
        );
    }
}
