<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;
use MageQL\Context;

class MageQL_Catalog_Model_Attributes_Image_Product extends MageQL_Core_Model_Attributes_Image_Abstract {
    /**
     * @var Mage_Catalog_Model_Product
     */
    protected $src;
    /**
     * @var string
     */
    protected $attrCode;
    /**
     * @var string
     */
    protected $value;

    public function __construct(
        Mage_Catalog_Model_Product $product,
        string $attrCode,
        string $value
    ) {
        $this->src = $product;
        $this->attrCode = $attrCode;
        $this->value = $value;
    }

    public function getSrc(array $args, Context $context, ResolveInfo $info): string {
        $helper = Mage::helper("catalog/image");

        $helper->init($this->src, $this->attrCode, $this->value);
        $helper->keepFrame($args["fill"] ?? false);

        if(array_key_exists("height", $args) || array_key_exists("width", $args)) {
            $helper->resize($args["width"] ?? null, $args["height"] ?? null);
        }

        return (string)$helper;
    }
}
