<?php

declare(strict_types=1);

/**
 * @psalm-type ProductSortInput array{
 *   code: string,
 *   order: MageQL_Catalog_Model_Sort::ORDER_ASC|MageQL_Catalog_Model_Sort::ORDER_DESC,
 * }
 */
abstract class MageQL_Catalog_Model_Product_AbstractSearchableCollection
    extends MageQL_Catalog_Model_Product_AbstractSortableCollection
    implements MageQL_Catalog_Model_Product_SearchableCollectionInterface {

    /**
     * @var ?string
     */
    private $redirect = null;

    /**
     * @return ?string
     */
    public function getRedirect(): ?string
    {
        return $this->redirect;
    }

    /**
     * @param ?string $redirect
     */
    public function setRedirect(?string $redirect): void
    {
        $this->redirect = $redirect;
    }
}
