<?php

declare(strict_types=1);

/**
 * An interface for a filterable and sortable collection wrapping containing Mage_Catalog_Model_Product.
 *
 * @psalm-type ProductSortInput array{
 *   code: string,
 *   order: MageQL_Catalog_Model_Sort::ORDER_ASC|MageQL_Catalog_Model_Sort::ORDER_DESC,
 * }
 */
interface MageQL_Catalog_Model_Product_SortableCollectionInterface
    extends MageQL_Catalog_Model_Product_FilterableCollectionInterface {
    /**
     * @return Array<MageQL_Catalog_Model_Sort>
     */
    public function getSortableBy(): array;

    /**
     * @param ?ProductSortInput $sort
     */
    public function setSort(?array $sort): void;
}
