<?php

declare(strict_types=1);

/**
 * @psalm-type ProductFilterInput array{
 *   code: string,
 *   value?: ?string,
 *   minValue?: ?float,
 *   maxValue?: ?float,
 *   incVat?: ?bool,
 * }
 * @psalm-type AppliedProductFilterValue array{code:string, value:string}
 * @psalm-type AppliedProductFilterRange array{code:string, minValue:?float, maxValue:?float}
 * @psalm-type AppliedProductFilter AppliedProductFilterValue | AppliedProductFilterRange
 */
interface MageQL_Catalog_Model_Product_FilterableCollectionInterface
    extends MageQL_Catalog_Model_Product_CollectionInterface {
    /**
     * @return Array<MageQL_Catalog_Model_Product_Filter_Abstract>
     */
    public function getFilterableBy(): array;

    /**
     * @param Array<ProductFilterInput> $filters
     */
    public function setFilters(array $filters): void;

    /**
     * Returns a list of the applied product attribute filters.
     *
     * @return Array<AppliedProductFilter>
     */
    public function getAppliedFilters(): array;
}
