<?php

declare(strict_types=1);

/**
 * @psalm-type ProductSortInput array{
 *   code: string,
 *   order: MageQL_Catalog_Model_Sort::ORDER_ASC|MageQL_Catalog_Model_Sort::ORDER_DESC,
 * }
 */
abstract class MageQL_Catalog_Model_Product_AbstractSortableCollection
    extends MageQL_Catalog_Model_Product_AbstractFilterableCollection
    implements MageQL_Catalog_Model_Product_SortableCollectionInterface {

    /**
     * @return ProductSortInput
     */
    abstract public function getDefaultSort(): array;

    /**
     * @return Array<MageQL_Catalog_Model_Sort>
     */
    public function getSortableBy(): array {
        $result = [];
        $config = Mage::getSingleton("catalog/config");

        foreach($config->getAttributesUsedForSortBy() as $attr) {
            $result[] = New MageQL_Catalog_Model_Sort($attr->getAttributeCode(), $attr->getStoreLabel());
        }

        return $result;
    }

    /**
     * @param ProductSortInput $sortBy
     */
    public function applySort(array $sortBy): void {
        $config = Mage::getSingleton("catalog/config");
        $attr = $config->getAttribute(Mage_Catalog_Model_Product::ENTITY, $sortBy["code"]);

        if ( ! $attr || ! $attr->getUsedForSortBy()) {
            throw new MageQL_Catalog_BadAttributeSortException($sortBy["code"]);
        }

        $this->collection->addAttributeToSort($sortBy["code"], $sortBy["order"]);
        if ($sortBy["code"] !== 'entity_id') {
            $this->collection->addAttributeToSort('entity_id', MageQL_Catalog_Model_Sort::ORDER_DESC);
        }
    }

    /**
     * @param ?ProductSortInput $sort
     */
    public function setSort(?array $sort): void {
        $this->applySort($sort ?: $this->getDefaultSort());
    }
}
