<?php

declare(strict_types=1);

/**
 * Select or multiselect attribute values.
 */
class MageQL_Catalog_Model_Product_Filter_Attribute_Bucket
    extends MageQL_Catalog_Model_Product_Filter_Attribute_Abstract {
    /**
     * @var ?Array<MageQL_Catalog_Model_Filter_Value>
     */
    protected $data;

    public function getTypeName(): string {
        return "ProductFilterBucket";
    }

    /**
     * @return Array<MageQL_Catalog_Model_Filter_Value>
     */
    public function getValues(): array {
        if($this->data === null) {
            $conn = $this->collection->getResource()->getReadConnection();
            $select = clone $this->collection->getSelect();

            $valueCol = $this->attribute->getAttributeCode()."_value";

            $select->reset(Zend_Db_Select::COLUMNS);
            $select->reset(Zend_Db_Select::ORDER);
            $select->reset(Zend_Db_Select::LIMIT_COUNT);
            $select->reset(Zend_Db_Select::LIMIT_OFFSET);
            $select->distinct(true);
            $select->columns([
                "value" => $valueCol,
            ]);
            $select->where(sprintf("%s IS NOT NULL", $conn->quoteIdentifier($valueCol)));

            $data = $conn->query($select)->fetchAll();

            $this->data = array_map(function(array $row): MageQL_Catalog_Model_Filter_Value {
                return new MageQL_Catalog_Model_Filter_AttributeValue($row["value"]);
            }, $data);
        }

        return $this->data;
    }

    public function hasData(): bool {
        return !empty($this->getValues());
    }
}
