<?php

declare(strict_types=1);

/**
 * @psalm-type ProductSortInput array{
 *   code: string,
 *   order: MageQL_Catalog_Model_Sort::ORDER_ASC|MageQL_Catalog_Model_Sort::ORDER_DESC,
 * }
 */
class MageQL_Catalog_Model_Product_Collection_Products
    extends MageQL_Catalog_Model_Product_AbstractSearchableCollection {
    const DEFAULT_SORT = [
        // This should be a sortable attribute at all times (is one by default)
        // and therefore we do not need to add it to the possible sorts
        "code" => "name",
        "order" => MageQL_Catalog_Model_Sort::ORDER_ASC,
    ];

    public function __construct(Mage_Core_Model_Store $store) {
        $collection = Mage::getModel("catalog/product")->getCollection();

        // Just plain URLs here since we do not have a category
        $collection->addUrlRewrite();

        parent::__construct($collection, $store);
    }

    /**
     * @return ProductSortInput
     */
    public function getDefaultSort(): array {
        return self::DEFAULT_SORT;
    }
}
