<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

abstract class MageQL_Catalog_Model_Product_AbstractCollection
    implements MageQL_Catalog_Model_Product_CollectionInterface {
    /**
     * @var Mage_Catalog_Model_Resource_Product_Collection
     */
    protected $collection;
    /**
     * @var Mage_Core_Model_Store
     */
    protected $store;

    protected function __construct(
        Mage_Catalog_Model_Resource_Product_Collection $collection,
        Mage_Core_Model_Store $store
    ) {
        $visibility = ["in" => [
            Mage_Catalog_Model_Product_Visibility::VISIBILITY_IN_CATALOG,
            Mage_Catalog_Model_Product_Visibility::VISIBILITY_BOTH
        ]];

        // We do not yet select any attributes, that is done when we
        // fetch the data in the items resolver
        $collection->addAttributeToFilter("visibility", $visibility);
        $collection->addStoreFilter($store);
        $collection->addPriceData();
        $collection->addTaxPercents();

        $this->collection = $collection;
        $this->store = $store;
    }

    public function getItems(ResolveInfo $info): array {
        $fields = Mage::helper("mageql_catalog")->getSelectedFields($info, []);

        foreach($fields as $col) {
            $this->collection->addAttributeToSelect($col);
        }

        return $this->collection->getItems();
    }

    public function getSize(): int {
        return (int)$this->collection->getSize();
    }

    public function setPage(?int $page, ?int $pageSize): void {
        // We call this directly on the select to prevent magento from stopping us from
        // going off the end of the list. (setCurPage() prevents this, which is not correct
        // from an API PoV)
        $this->collection->getSelect()
             ->limitPage(
                 max($page ?: self::DEFAULT_PAGE, 1),
                 max(min($pageSize ?: self::DEFAULT_PAGE_SIZE, self::MAX_PAGE_SIZE), 1)
             );
    }
}
