<?php

declare(strict_types=1);

/**
 * @psalm-type ProductFilterInput array{
 *   code: string,
 *   value?: ?string,
 *   minValue?: ?float,
 *   maxValue?: ?float,
 *   incVat?: ?bool,
 * }
 */
interface MageQL_Catalog_Model_Filter_Product_Interface {
    /**
     * @return Array<MageQL_Catalog_Model_Product_Filter_Abstract>
     */
    public function getFilterableBy(
        Mage_Catalog_Model_Resource_Product_Collection $collection
    ): array;

    /**
     * Checks if a filter can be applied by this instance, if it can apply it
     * is applied to the collection and true is returned
     *
     * @param ProductFilterInput $filter
     */
    public function applyFilter(
        Mage_Catalog_Model_Resource_Product_Collection $collection,
        array $filter
    ): bool;
}
