<?php

declare(strict_types=1);

use GraphQL\Error\ClientAware;

class MageQL_Catalog_NoSuchFilterException extends Exception implements ClientAware {
    public function __construct(string $code) {
        parent::__construct(sprintf("Filter with code '%s' does not exist.", $code));
    }

    public function isClientSafe() {
        return true;
    }

    public function getCategory() {
        return "mageql_catalog";
    }
}

