<?php

declare(strict_types=1);

/**
 * Boolean attribute values.
 */
class MageQL_Catalog_Model_Product_Filter_Attribute_Boolean
    extends MageQL_Catalog_Model_Product_Filter_Attribute_Abstract {
    public function getTypeName(): string {
        return "ProductFilterBoolean";
    }

    public function hasData(): bool {
        $conn = $this->collection->getResource()->getReadConnection();
        $select = clone $this->collection->getSelect();

        $valueCol = $this->attribute->getAttributeCode();

        $select->reset(Zend_Db_Select::COLUMNS);
        $select->reset(Zend_Db_Select::ORDER);
        $select->reset(Zend_Db_Select::LIMIT_COUNT);
        $select->reset(Zend_Db_Select::LIMIT_OFFSET);
        $select->columns([
            "count" => new Zend_Db_Expr("COUNT(1)"),
        ]);
        $select->where(sprintf("%s IS NOT NULL", $conn->quoteIdentifier($valueCol)));

        $data = $conn->query($select)->fetchColumn();


        return $data > 0;
    }
}
