<?php

declare(strict_types=1);

abstract class MageQL_Catalog_Model_Product_Filter_Attribute_Abstract extends MageQL_Catalog_Model_Product_Filter_Abstract {
    /**
     * @readonly
     * @var Mage_Eav_Model_Entity_Attribute_Abstract
     */
    protected $attribute;

    /**
     * @readonly
     * @var Mage_Catalog_Model_Resource_Product_Collection
     */
    protected $collection;

    public function __construct(
        Mage_Eav_Model_Entity_Attribute_Abstract $attribute,
        Mage_Catalog_Model_Resource_Product_Collection $collection
    ) {
        $this->attribute = $attribute;
        $this->collection = $collection;
    }

    public function getCode(): string {
        return $this->attribute->getAttributeCode();
    }

    public function getLabel(): string {
        return $this->attribute->getStoreLabel();
    }
}
