<?php

declare(strict_types=1);

abstract class MageQL_Catalog_Model_Product_Filter_Abstract {
    /**
     * The code used to identify the filter.
     */
    abstract public function getCode(): string;

    /**
     * Filter label to display to the customer.
     */
    abstract public function getLabel(): string;

    /**
     * Returns true if the filter has possible options which when
     * added will yield results.
     */
    abstract public function hasData(): bool;

    /**
     * GraphQL type-name for this filter, must implement ProductFilter.
     */
    abstract public function getTypeName(): string;
}
