<?php

declare(strict_types=1);

use Crossroads\Magento\Test\Integration\Config;
use Crossroads\Magento\Test\Integration\Request;
use Crossroads\Magento\Test\Integration\TestCase;

/**
 * @runTestsInSeparateProcesses
 * @preserveGlobalState disabled
 */
class LogTest extends TestCase {
    public function testSystemLog(): void {
        $this->initMagento();

        $this->assertEquals("", $this->getLogContents());
        $this->assertEquals([], $this->getLogEntries());

        Mage::log("Test logging");
        $line = __LINE__ - 1;

        $this->assertStringContainsString("Test logging", $this->getLogContents());
        $this->assertEquals([
            [
                "level" => 7,
                "level_name" => "DEBUG",
                "channel" => "system",
                "message" => "Test logging",
                "context" => [
                    "storeCode" => "testing",
                    "caller" => [
                        "class" => "LogTest",
                        "function" => "testSystemLog",
                        "location" => [
                            "file" => __FILE__,
                            "line" => $line,
                        ],
                    ],
                ],
                "extra" => [],
            ],
        ], $this->getLogEntries());

        // Ensure it is cleaned again
        $this->setUp();

        $this->initMagento();

        $this->assertEquals("", $this->getLogContents());
        $this->assertEquals([], $this->getLogEntries());
    }

    public function testExceptionLog(): void {
        $this->initMagento();

        $this->assertEquals("", $this->getLogContents());
        $this->assertEquals([], $this->getLogEntries());

        Mage::logException(new Exception("Test exception log"));
        $line = __LINE__ - 1;

        $this->assertStringContainsString("Test exception log", $this->getLogContents());

        $entries = $this->getLogEntries();

        // We have to skip the stack trace
        unset($entries[0]["context"]["exception"]["trace"]);

        $this->assertEquals([
            [
                "level" => 3,
                "level_name" => "ERR",
                "channel" => "exception",
                "message" => "Test exception log",
                "context" => [
                    "storeCode" => "testing",
                    "caller" => [
                        "class" => "LogTest",
                        "function" => "testExceptionLog",
                        "location" => [
                            "file" => __FILE__,
                            "line" => $line,
                        ],
                    ],
                    "exception" => [
                        "class" => "Exception",
                        "message" => "Test exception log",
                        "code" => 0,
                        "file" => __FILE__.":".$line,
                    ],
                ],
                "extra" => [],
            ],
        ], $entries);

        // Ensure it is cleaned again
        $this->setUp();

        $this->initMagento();

        $this->assertEquals("", $this->getLogContents());
        $this->assertEquals([], $this->getLogEntries());
    }
}
