<?php

declare(strict_types=1);

namespace Crossroads\Magento\Test\Integration;

use Mage;
use Mage_Core_Model_Cookie;
use Varien_Object;

class Session extends Varien_Object {
    /**
     * @var ?string
     */
    static $sessionName;
    /**
     * @var Array<string, Array<string, string>>
     */
    protected $namespaces = [];

    /**
     * @param ?string $sessionName
     * @return $this
     */
    public function start($sessionName = null) {
        if( ! self::$sessionName) {
            self::$sessionName = $sessionName ?: "default";
        }

        return $this;
    }

    /**
     * @param string $name
     * @return $this
     */
    public function setSessionName($name) {
        self::$sessionName = $name;

        return $this;
    }

    /**
     * @return ?string
     */
    public function getSessionName() {
        return static::$sessionName;
    }

    /**
     * @param string $namespace
     * @param ?string $sessionName
     * @return $this
     */
    public function init($namespace, $sessionName = null) {
        if( ! self::$sessionName) {
            $this->start($sessionName);
        }

        if( ! array_key_exists($namespace, $this->namespaces)) {
            $this->namespaces[$namespace] = [];
        }

        return $this;
    }

    /**
     * @return Mage_Core_Model_Cookie
     */
    public function getCookie() {
        return Mage::getSingleton("core/cookie");
    }

    /**
     * @return $this
     */
    public function regenerateSessionId() {
        // TODO: Should we update the cookie here?
        return $this;
    }
}

