<?php

declare(strict_types=1);

use Crossroads\Magento\Test\Integration\Config;
use Crossroads\Magento\Test\Integration\Request;
use Crossroads\Magento\Test\Integration\TestCase;

/**
 * @runTestsInSeparateProcesses
 * @preserveGlobalState disabled
 */
class ConfigTest extends TestCase {
    public function testOverwriteConfig(): void {
        Config::setConfigPath("default/my/config/value", "FOOBAR");

        $this->initMagento();

        $this->assertEquals("FOOBAR", Mage::app()->getStore()->getConfig("my/config/value"));
    }
}
