<?php

declare(strict_types=1);

namespace Crossroads\Magento\Test\Integration;

use Mage;
use Zend_Controller_Request_Abstract;
use Mage_Core_Controller_Varien_Action;
use Mage_Core_Controller_Response_Http;
use Throwable;

use PHPUnit\Framework\TestCase as BaseCase;

class TestCase extends BaseCase {
    public function getPreserveSession(): bool {
        return true;
    }

    public function setUp(): void {
        MagentoManager::setUp(getcwd()."/vendor/awardit/magento-lts");

        if( ! $this->getPreserveSession()) {
            $_SESSION = [];
        }

        // TODO: After test to ensure log files are empty
    }

    public function tearDown(): void {
        MagentoManager::logQueries();
    }

    public function onNotSuccessfulTest(Throwable $t): void {
        MagentoManager::logQueries();

        throw $t;
    }

    /**
     * @deprecated
     */
    public function getSystemLog(): string {
        return MagentoManager::readLogFile("system.log");
    }

    /**
     * @deprecated
     */
    public function getExceptionLog(): string {
        return MagentoManager::readLogFile("exception.log");
    }

    public function initMagento(): void {
        MagentoManager::init();
    }

    public static function runRequest(
        Request $request
    ): Response {
        return MagentoManager::runRequest($request);
    }

    public static function loginCustomer(int $customerId): void {
        $sess     = Mage::getSingleton("customer/session");
        $customer = Mage::getModel("customer/customer")
            ->setWebsiteId(Mage::app()->getStore()->getWebsiteId())
            ->load($customerId);
        $sess->setCustomerAsLoggedIn($customer);
    }

    /**
     * @psalm-suppress UnresolvableInclude
     */
    public static function createController(
        string $module,
        string $controller
    ): Mage_Core_Controller_Varien_Action {
        $fileName  = Mage::getModuleDir("controllers", $module) . DS . ucwords($controller, DS) . "Controller.php";
        $className = $module . "_" . ucwords($controller)."Controller";
        $app       = Mage::app();
        $request   = $app->getRequest();
        $response  = $app->getResponse();

        require_once $fileName;

        return Mage::getControllerInstance($className, $request, $response);
    }
}
