<?php

declare(strict_types=1);

namespace Crossroads\Magento\Test\Integration;

use Exception;
use Varien_Profiler;
use Mage_Core_Model_Config;
use Awardit_Magento_EnvConfig;
use Varien_Simplexml_Element;

class Config extends Awardit_Magento_EnvConfig {
    /**
     * @var Array<string, string|array>
     */
    protected static $testingConfig = [];

    public static function unsetConfigPath(string $path): void {
        $list = explode("/", $path);

        self::$testingConfig = excludePath(self::$testingConfig, $list);
    }

    public static function setConfigPath(string $path, ?string $value): void {
        $list = explode("/", $path);
        $config = [
            array_pop($list) => $value,
        ];

        foreach(array_reverse($list) as $key) {
            $config = [
                $key => $config,
            ];
        }

        self::$testingConfig = array_replace_recursive(self::$testingConfig, $config);
    }

    protected function createLocalConfig(array $env): array {
        $config = parent::createLocalConfig($env);

        return array_replace_recursive($config, self::$testingConfig);
    }
}

function excludePath(array $config, array $path): array {
    if(empty($config)) {
        return $config;
    }

    $key = array_shift($path);

    foreach($config as $k => $c) {
        if($k === $key) {
            if(empty($path)) {
                unset($config[$k]);
            }
            else if(is_array($c)) {
                $children = excludePath($c, $path);

                if(empty($children)) {
                    unset($config[$k]);
                }
                else {
                    $config[$k] = $children;
                }
            }
        }
    }

    return $config;
}
