<?php

declare(strict_types=1);

namespace Crossroads\Magento\Test\Integration;

use Mage;
use Varien_Object;

class Session extends Varien_Object {
    static $sessionName;
    protected $namespaces = [];

    public function start($sessionName = null) {
        if( ! self::$sessionName) {
            self::$sessionName = $sessionName ?: "default";
        }

        return $this;
    }

    public function setSessionName($name) {
        self::$sessionName = $name;

        return $this;
    }

    public function getSessionName() {
        return static::$sessionName;
    }

    public function init($namespace, $sessionName = null) {
        if( ! self::$sessionName) {
            $this->start($sessionName);
        }

        if( ! array_key_exists($namespace, $this->namespaces)) {
            $this->namespaces[$namespace] = [];
        }

        return $this;
    }

    public function getCookie() {
        return Mage::getSingleton("core/cookie");
    }

    public function regenerateSessionId() {
        // TODO: Should we update the cookie here?
        return $this;
    }
}

