<?php

declare(strict_types=1);

use Crossroads\Magento\Test\Integration\Config;
use Crossroads\Magento\Test\Integration\Request;
use Crossroads\Magento\Test\Integration\TestCase;

/**
 * @runTestsInSeparateProcesses
 * @preserveGlobalState disabled
 */
class LogTest extends TestCase {
    public function testSystemLog() {
        $this->initMagento();

        $this->assertEquals("", $this->getSystemLog());
        $this->assertEquals("", $this->getExceptionLog());

        Mage::log("Test logging");

        $this->assertStringContainsString("Test logging\n", $this->getSystemLog());
        $this->assertEquals("", $this->getExceptionLog());

        // Ensure it is cleaned again
        $this->setUp();

        $this->initMagento();

        $this->assertEquals("", $this->getSystemLog());
        $this->assertEquals("", $this->getExceptionLog());
    }

    public function testExceptionLog() {
        $this->initMagento();

        $this->assertEquals("", $this->getSystemLog());
        $this->assertEquals("", $this->getExceptionLog());

        Mage::logException(new Exception("Test exception log"));

        $this->assertStringContainsString("Exception: Test exception log in", $this->getExceptionLog());
        $this->assertEquals("", $this->getSystemLog());

        // Ensure it is cleaned again
        $this->setUp();

        $this->initMagento();

        $this->assertEquals("", $this->getSystemLog());
        $this->assertEquals("", $this->getExceptionLog());
    }
}
