<?php

declare(strict_types=1);

use PHPUnit\Framework\TestCase;
use Crossroads\Magento\Test\Integration\Request;

/**
 * @covers Crossroads\Magento\Test\Integration\Request
 */
class RequestTest extends TestCase {
    public function testBasic() {
        $r = new Request("");

        $this->assertEquals("GET", $r->getMethod());
        $this->assertEquals("", $r->getPathInfo());
        $this->assertEquals("", $r->getRequestUri());
        $this->assertEquals("", $r->getRawBody());
        $this->assertEquals(true, $r->isSecure());
    }

    public function testPath() {
        $r = new Request("/the/path");

        $this->assertEquals("GET", $r->getMethod());
        $this->assertEquals("/the/path", $r->getPathInfo());
        $this->assertEquals("/the/path", $r->getRequestUri());
        $this->assertEquals("", $r->getRawBody());
        $this->assertEquals(true, $r->isSecure());
    }

    public function testQuery() {
        $r = new Request("/the/path?and=query");

        $this->assertEquals("GET", $r->getMethod());
        $this->assertEquals("/the/path", $r->getPathInfo());
        $this->assertEquals("/the/path?and=query", $r->getRequestUri());
        $this->assertEquals("", $r->getRawBody());
        $this->assertEquals(true, $r->isSecure());
    }

    public function testMethod() {
        $r = new Request("GET /the");

        $this->assertEquals("GET", $r->getMethod());
        $this->assertEquals("/the", $r->getPathInfo());
        $this->assertEquals("/the", $r->getRequestUri());
        $this->assertEquals("", $r->getRawBody());
        $this->assertEquals(true, $r->isSecure());
    }

    public function testMethodAndQuery() {
        $r = new Request("GET /the/path?and=query");

        $this->assertEquals("GET", $r->getMethod());
        $this->assertEquals("/the/path", $r->getPathInfo());
        $this->assertEquals("/the/path?and=query", $r->getRequestUri());
        $this->assertEquals("", $r->getRawBody());
        $this->assertEquals(true, $r->isSecure());
    }
}
