<?php

declare(strict_types=1);

use Spatie\Snapshots\MatchesSnapshots;

use Crossroads\Magento\Test\Integration\TestCase;
use Crossroads\Magento\Test\Integration\Request;

/**
 * @runTestsInSeparateProcesses
 * @preserveGlobalState disabled
 */
class ProductTest extends TestCase {
    public function testCreateImage() {
        $this->initMagento();

        $image = Mage::helper("catalog/image")->init(Mage::getModel("catalog/product"), "small_image");

        $this->assertEquals("https://example.com/media/catalog/product/cache/2/small_image/9df78eab33525d08d6e5fb8d27136e95/placeholder.jpg", (string)$image);
    }
}
