<?php

declare(strict_types=1);

namespace Crossroads\Magento\Test\Integration;

use Mage_Core_Controller_Request_Http;

class Request extends Mage_Core_Controller_Request_Http {
    protected $_rawBody   = false;
    protected $headers    = [];
    protected $post       = [];
    protected $query      = [];
    protected $method     = "GET";
    protected $serverData = [];
    protected $_baseUrl   = "";

    public static function normalizeHeaderName($name) {
        return strtoupper(str_replace('-', '_', $name));
    }

    public function __construct($call, array $headers = [], $body = false) {
        $parts = explode(" ", $call, 2);

        if(count($parts) === 2) {
            $this->method = $parts[0];
            $this->setRequestUri($parts[1]);
        }
        else {
            $this->setRequestUri($parts[0]);
        }

        $this->setPathInfo();

        $this->setHeaders($headers);

        $this->_rawBody = $body;
    }

    public function getQuery($key = null, $default = null) {
        if($key === null) {
            return $this->query;
        }

        return (isset($this->query[$key])) ? $this->query[$key] : $default;
    }

    public function setQuery($spec, $value = null) {
        if((null === $value) && !is_array($spec)) {
            throw new Zend_Controller_Exception('Invalid value passed to setQuery(); must be either array of values or key/value pair');
        }

        if((null === $value) && is_array($spec)) {
            foreach ($spec as $key => $value) {
                $this->setQuery($key, $value);
            }

            return $this;
        }

        $this->query[(string) $spec] = $value;

        return $this;
    }

    public function getPost($key = null, $default = null) {
        if(null === $key) {
            return $this->post;
        }

        return (isset($this->post[$key])) ? $this->post[$key] : $default;
    }

    public function setPost($spec, $value = null) {
        if((null === $value) && !is_array($spec)) {
            throw new Zend_Controller_Exception('Invalid value passed to setPost(); must be either array of values or key/value pair');
        }

        if((null === $value) && is_array($spec)) {
            foreach ($spec as $key => $value) {
                $this->setPost($key, $value);
            }

            return $this;
        }

        $this->post[(string) $spec] = $value;

        return $this;
    }

    public function getRawBody() {
        return $this->_rawBody;
    }

    public function setHeaders(array $headers) {
        $this->headers = array_combine(array_map(__CLASS__."::normalizeHeaderName", array_keys($headers)), array_values($headers));

        return $this;
    }

    public function setHeader($name, $value) {
        $this->headers[self::normalizeHeaderName($name)] = $value;

        return $this;
    }

    public function setMethod(string $method) {
        $this->method = $method;

        return $this;
    }

    public function getMethod() {
        return $this->method;
    }

    public function getHeader($header) {
        if(empty($header)) {
            throw new Zend_Controller_Request_Exception('An HTTP header name is required');
        }

        $temp = self::normalizeHeaderName($header);

        return isset($this->headers[$temp]) ? $this->headers[$temp] : null;
    }

    public function _canBeStoreCodeInUrl() {
        // Never
        return false;
    }

    public function isSecure() {
        // We are always secure during test ;)
        return true;
    }
}
