<?php

declare(strict_types=1);

use Crossroads\Magento\Test\Integration\Request;
use Crossroads\Magento\Test\Integration\TestCase;

/**
 * @runTestsInSeparateProcesses
 * @preserveGlobalState disabled
 */
class BaseTest extends TestCase {
    public function testRootRequest(): void {
        $resp = $this->runRequest(new Request("GET /", [
        ]));

        $this->assertEquals(200, $resp->getHttpResponseCode());
        $this->assertStringContainsString("Default welcome msg! ", $resp->getBody());
        $this->assertStringContainsString("Testing Magento |", $resp->getBody());
    }

    public function testNotFoundRequest(): void {
        $resp = $this->runRequest(new Request("GET /this-should-not-be-found-at-all", [
        ]));

        $this->assertEquals(404, $resp->getHttpResponseCode());
        $this->assertStringContainsString("The page you requested was not found", $resp->getBody());
        $this->assertStringContainsString("Default welcome msg! ", $resp->getBody());
        $this->assertStringContainsString("Testing Magento |", $resp->getBody());
    }

    public function testInit(): void {
        $this->initMagento();

        $this->assertInstanceOf(Mage_Core_Model_Store::class, Mage::app()->getStore());
        $this->assertEquals("Test Store", Mage::app()->getStore()->getName());
    }
}
