# Magento Testing Library

Testing library for Magento 1.9

## Installation in a Magento Module project

Add the following to your `composer.json` to install Magento into the folder
`magento` in the root of the project:

```json
{
  "autoload-dev": {
    "psr-0": {
      "": ["magento/app/code/local", "magento/app/code/community", "magento/app/code/core", "magento/lib"]
    }
  },
  "extra": {
    "include-root-package": true,
    "magento-core-package-type": "magento-source",
    "magento-deploystrategy": "symlink",
    "magento-root-dir": "magento"
  }
}
```

The above properties will only apply if the project is the root project for
composer.

Then to require the necessary modules:

```bash
composer require --dev aydin-hassan/magento-core-composer-installer \
  magento-hackathon/magento-composer-installer \
  openmage/magento-lts \
  crossroads/magento-testing-library
```

## Bootstrapping the Manager

Bootstrap the `MagentoManager` in the test suite by supplying the path to the `magento-root-dir`:

```php
use Crossroads\Magento\Test\Integration\MagentoManager;

require_once __DIR__."/../vendor/autoload.php";

MagentoManager::setUp(getcwd()."/magento");

// More bootstrapping here for tests (like global fixtures and similar things)
```
