# Crossroads Magento Performance module

A module containing overrides with bugfixes and performance improvements for Magento.

This module is based on Magento 1.9.4.2.

## Installing

Add the `composer.crossroads.se` repository, `autoload` instructions and and
then install the module:

```json
{
  "require": {
    "crossroads/magento-performance": "dev-master",
  },
  "repositories": [
    {
      "type": "composer",
      "url":  "https://composer.crossroads.se"
    }
  ],
  "autoload": {
    "psr-0": {
      "": ["app/code/local", "app/code/community", "app/code/core", "lib"]
    }
  },
  "extra": {
    "magento-root-dir":      ".",
    "auto-append-gitignore": true
  }
}
```

Note that the `autoload` key is **REQUIRED** since this module will replace
`Varien_Autoload` with a shim over Composer's Autoloader.

### Building for production

Run `dump-autoload` after installing composer modules:

```bash
composer dump-autoload --optimize
```

It is important that it is run **AFTER** `composer install` or `composer update`
to make sure that the autoloader is considering all the overrides and modules
when generating the classmap.

To make sure that the modules have been correctly installed the following
command can be run to redeploy all the magento moudles:

```bash
composer run-script post-install-cmd -vvv -- --redeploy
```

See [Autoloader Optimization](https://getcomposer.org/doc/articles/autoloader-optimization.md)
for more in-depth information.

## Bugfixes

* `Mage_Adminhtml_Block_Customer_Edit_Tab_Account` is overridden to provide
  missing `adminhtml_catalog_customer_edit_element_types` event enabling observers
  to add element types to the admin form.

* `Mage_Catalog_Model_Product_Type_Abstract` is overridden to provide support
  for required custom options on configurable products.
  
* `Mage_Catalog_Model_Resource_Product_Link_Product_Collection` has added
  filtering of the count query to return the correct count of linked products.

* `Mage_CatalogInventory_Model_Observer` is overridden to fix crashes caused by
  missing `checkQtyIncrements` on stock items (Magento's "compatible" default
  items are not compatible otherwise).

* `Mage_Core_Model_Config`: Overridden to no longer try to include the no-longer-used
  `config.mysql4.xml` configuration files.

* `Mage_Core_Model_Translate` is overridden to fix issues with `vsprintf` causing
  errors with missing data parameters.

* `Mage_Eav_Model_Entity_Abstract` is overridden to preserve stack traces.

* `Mage_Eav_Model_Entity_Increment_Numeric` is overriden to fix a deprecation issue
  with `strpos` and integer needles, the needle is now converted to a string.

* `Mage_Sales_Model_Config_Ordered` is overridden to provide a stable sort independent of
  PHP version. In PHP 7 (and alternative PHP implementations) Magento cannot rely on
  implementation details of `usort`.

* `Mage_Sales_Model_Quote_Address` is modified to only write to `same_as_billing`
  when saving if it doesn't already have a value set.

* Indexer used "DISABLE KEYS" and "ENABLE KEYS" when running. We had problems with
  database hanging and found out that removing this might help. Overridden files:
  `Mage_Catalog_Model_Resource_Product_Indexer_Eav_Abstract`,
  `Mage_Catalog_Model_Resource_Product_Indexer_Price_Default`,
  `Mage_Catalog_Model_Resource_Product_Indexer_Price`,
  `Mage_Index_Model_Indexer_Abstract`,
  `Mage_Index_Model_Resource_Abstract`

* `Mage_Rss_Helper_Data` is overriden to prevent session initialization unless actually
  needed.

* `Mage_Eav_Model_Attribute_Source_Table` now creates a limited index for `TEXT`-fields.
  Requires modifications to `Varieb_Db_Adapter_Pdo_Mysql`, also included.

* Deprecated uses of `each()` in PHP 7.2

* Fixes for `null` parameters to `count()` in PHP 7.2

* `Flagbit_ChangeAttributeSet_Adminhtml_Catalog_ProductController` overridden to not
  turn off realtime-indexing.

* `Mage_Index_Model_Resource_Abstract` is overridden to provide null-values for global
  namespace in the case of missing values. This fixes issues when loading attribute data
  for collections without flat tables (fixes issues with missing `special_price` in checkout).

* `Mage_Core_Model_Quote_Item_Abstract`: Fix for recursive arrays when updating qty
  for bundles.

## Performance improvements

* `Mage_Catalog_Model_Product_Type_Abstract` is overridden to improve performance when
  fetching product attributes. This greatly speeds up listing and display of configurable
  products.

* `Varien_Autoload` is replaced with Composer's Autoloader.

## Features

* `Mage_Adminhtml_Model_System_Config_Source_Email_Template`: Override enabling
  the user to select an empty template, resulting in no email sent.

* `Varien_Simplexml_Config`: Override which will throw exceptions in developer mode
  if XML-files are missing or cannot be parsed.

* `Mage_Core_Controller_Front_Action` can now have its session namespace configured
  using *System* -> *Configuration* -> *Web* -> *Session Cookie Management* ->
  *Frontend Namespace*. This will change the cookie-name for the frontend cookie.