<?php

/**
 * Composer based autoloader for Magento.
 *
 * Does NOT add anything to the autoloader, instead the package using
 * crossroads/magento-performance should add autoloader instructions:
 *
 * ```
 * "autoload": {
 *   "psr-0": {
 *     "": ["app/code/local", "app/code/community", "app/code/core", "lib"]
 *   }
 * }
 * ```
 */
class Varien_Autoload {
    private static $instance = null;
    private static $loader = null;

    static public function instance() {
        if( ! static::$instance) {
            static::$instance = new Varien_Autoload();
        }

        return static::$instance;
    }

    static public function register() {
        if( ! static::$loader) {
            static::$loader = require BP . "/vendor/autoload.php";
        }
    }

    static public function registerScope($code) {
    }
}