# Crossroads Magento Performance module

A module containing overrides with bugfixes and performance improvements for Magento.

This module is based on Magento 1.9.3.6.

## Bugfixes

* `Mage_Adminhtml_Block_Customer_Edit_Tab_Account` is overridden to provide
  missing `adminhtml_catalog_customer_edit_element_types` event enabling observers
  to add element types to the admin form.

* `Mage_Catalog_Model_Product_Type_Abstract` is overridden to provide support
  for required custom options on configurable products.

* `Mage_CatalogInventory_Model_Observer` is overridden to fix crashes caused by
  missing `checkQtyIncrements` on stock items (Magento's "compatible" default
  items are not compatible otherwise).

* `Mage_Core_Model_Translate` is overridden to fix issues with `vsprintf` causing
  errors with missing data parameters.

* `Mage_Sales_Model_Config_Ordered` is overridden to provide a stable sort independent of
  PHP version. In PHP 7 (and alternative PHP implementations) Magento cannot rely on
  implementation details of `usort`.

* `Mage_Shipping_Model_Carrier_Abstract` is overridden to fix issues with empty values
  in `handling_fee`. This causes crashes due to warnings and errors in debug-builds.

* `Mage_Shipping_Model_Carrier_Tablerate` is overridden to fix an error stemming from a
  missing variable.

* Indexer used "DISABLE KEYS" and "ENABLE KEYS" when running. We had problems with
  database hanging and found out that removing this might help. Overridden files:
  `Mage_Catalog_Model_Resource_Product_Indexer_Eav_Abstract`,
  `Mage_Catalog_Model_Resource_Product_Indexer_Price_Default`,
  `Mage_Catalog_Model_Resource_Product_Indexer_Price`,
  `Mage_Index_Model_Indexer_Abstract`,
  `Mage_Index_Model_Resource_Abstract`

* `Mage_Rss_Helper_Data` is overriden to prevent session initialization unless actually
  needed.

* `Mage_Eav_Model_Attribute_Source_Table` now creates a limited index for `TEXT`-fields.
  Requires modifications to `Varieb_Db_Adapter_Pdo_Mysql`, also included.

* Deprecated uses of `each()` in PHP 7.2

* Deprecated use of `__autoload` in PHP 7.2

* Fixes for stricter inheritance checking on method signatures in PHP 7.2

* Fixes for `null` parameters to `count()` in PHP 7.2

* `Flagbit_ChangeAttributeSet_Adminhtml_Catalog_ProductController` overridden to not
  turn off realtime-indexing.

## Performance improvements

* `Mage_Catalog_Model_Product_Type_Abstract` is overridden to improve performance when
  fetching product attributes. This greatly speeds up listing and display of configurable
  products.

## Features

* `Mage_Adminhtml_Model_System_Config_Source_Email_Template`: Override enabling
  the user to select an empty template, resulting in no email sent.

* `Mage_Core_Controller_Front_Action` can now have its session namespace configured
  using *System* -> *Configuration* -> *Web* -> *Session Cookie Management* ->
  *Frontend Namespace*. This will change the cookie-name for the frontend cookie.