# Crossroads Magento Performance module

A module containing overrides with bugfixes and performance improvements for Magento.

This module is based on Magento 1.9.2.4.

## Bugfixes

* `Mage_Sales_Model_Config_Ordered` is overridden to provide a stable sort independent of
  PHP version. In PHP 7 (and alternative PHP implementations) Magento cannot rely on
  implementation details of `usort`.

* `Mage_Shipping_Model_Carrier_Abstract` is overridden to fix issues with empty values
  in `handling_fee`. This causes crashes due to warnings and errors in debug-builds.

* `Mage_Shipping_Model_Carrier_Tablerate` is overridden to fix an error stemming from a
  missing variable.

* Indexer used "DISABLE KEYS" and "ENABLE KEYS" when running. We had problems with
  database hanging and found out that removing this might help. Overridden files:
  `Mage_Catalog_Model_Resource_Product_Indexer_Eav_Abstract`,
  `Mage_Catalog_Model_Resource_Product_Indexer_Price_Default`,
  `Mage_Catalog_Model_Resource_Product_Indexer_Price`,
  `Mage_Index_Model_Indexer_Abstract`,
  `Mage_Index_Model_Resource_Abstract`

## Performance improvements

* `Mage_Catalog_Model_Product_Type_Abstract` is overridden to improve performance when
  fetching product attributes. This greatly speeds up listing and display of configurable
  products.