<?php

class Crossroads_LoginAsCustomer_Model_Observer extends Mage_Core_Model_Abstract {

    public function injectLoginAsCustomerButton($observer)
    {
        $block = $observer->getEvent()->getBlock();

        if ($block instanceof Mage_Adminhtml_Block_Customer_Edit) {
            if ($this->getCustomer() && $this->getCustomer()->getId()) {
                $block->addButton('loginAsCustomer', array(
                    'label' => Mage::helper('customer')->__('Login as Customer'),
                    'onclick' => 'popWin(\'' . $this->getLoginAsCustomerUrl() . '\', \'_blank\')',
                    'class' => 'loginAsCustomer',
                        ), 0);
            }
        }
    }

    public function getCustomer()
    {
        return Mage::registry('current_customer');
    }

    public function getLoginAsCustomerUrl()
    {
        if (Mage::getSingleton('customer/config_share')->isWebsiteScope()) {
            return Mage::helper('adminhtml')->getUrl('*/LoginAsCustomer/login/', array(
                        'customer_id' => $this->getCustomer()->getId(),
                        'website_id' => $this->getCustomer()->getWebsiteId(),
            ));
        }
    }

}
