<?php

class Crossroads_LoginAsCustomer_AdminloginController extends Mage_Core_Controller_Front_Action {

    public static $_validTimeframe = 120; // seconds +/-

    // Called by: /api/adminlogin/customer/<parameters>
    public function customerAction()
    {
        $param = Mage::helper("LoginAsCustomer")->base64url_decode($this->getRequest()->getParam("loginAsCustomer"));
        $info  = unserialize(Mage::helper("core")->decrypt($param));

        if (!empty($info["website_id"]) && !empty($info["customer_id"]) && !empty($info["timestamp"])) {

            $now = time();
            if ($now > ($info["timestamp"] - self::$_validTimeframe) && $now <  ($info["timestamp"] + self::$_validTimeframe)) {
                $customerSession = Mage::getSingleton("customer/session");

                // If logged in, log out first
                if ($customerSession->isLoggedIn()) {
                    $customerSession->logout();
                    $this->_redirectUrl($this->getRequest()->getRequestUri());
                    return;
                }

                $customerSession->loginById($info["customer_id"]);
            }
        }

        $this->_redirect("/");
    }

}
