<?php

class Crossroads_Klarna_Helper_Data extends Mage_Core_Helper_Abstract
{
    const QUOTE_FIELD_SSN = "socialSecurityNumber";

    const CONFIG_PATH_ENABLED_PCLASSES = "payment/Crossroads_Klarna_Invoice/enabled_pclasses";
    const CONFIG_PATH_MIN_ORDER_TOTAL  = "payment/Crossroads_Klarna_Invoice/min_order_total";

    const FIELD_RESERVATION_ID     = "klarna_reservation_id";
    const FIELD_INVOICE_ID         = "klarna_invoice_id";
    const FIELD_RESERVATION_STATUS = "klarna_reservation_status";
    const FIELD_EID                = "klarna_eid";
    const FIELD_SSN                = "klarna_ssn";
    const FIELD_PCLASS             = "klarna_selected_pclass";

    public function registerPayment(Varien_Event_Observer $observer) {
        $observer->getRegistry()->addMethod(new Crossroads_Klarna_Model_Payment_Invoice());
    }

    /**
     * Validate the social security number if we use our own payment method.
     */
    public function checkoutPostVerifyQuote(Varien_Event_Observer $observer) {
        $quote   = $observer->getQuote();
        $enabled = $this->getEnabledMethods($quote);

        if($quote->getPayment()->getMethod() !== "Crossroads_Klarna_Invoice") {
            return;
        }

        if( ! $quote->getPayment()->getAdditionalInformation(self::FIELD_SSN)) {
            throw Crossroads_API_ResponseException::create(400, "Missing required paymentMethodData.socialSecurityNumber", null, 11001);
        }

        if( ! filter_var($quote->getPayment()->getAdditionalInformation(self::FIELD_PCLASS), FILTER_VALIDATE_INT)) {
            throw Crossroads_API_ResponseException::create(400, "Missing or malformed required paymentMethodData.klarnaPclass, integer required", null, 11002);
        }

        if( ! in_array($quote->getPayment()->getAdditionalInformation(self::FIELD_PCLASS), $enabled)) {
            throw Crossroads_API_ResponseException::create(400, "The chosen klarnaPclass is not enabled.", null, 11003);
        }
    }

    public function getEnabledMethods($quote = null) {
        return array_filter(array_map("trim", explode(",", Mage::getStoreConfig(self::CONFIG_PATH_ENABLED_PCLASSES, $quote ? $quote->getStoreId() : null))));
    }
}
