<?php

class Crossroads_Klarna_Block_Adminhtml_System_Config_Pclasses extends Mage_Adminhtml_Block_System_Config_Form_Field {
    protected function _construct() {
        $this->setTemplate("Crossroads_Klarna/system/config/pclasses.phtml");

        parent::_construct();
    }

    protected function _getElementHtml(Varien_Data_Form_Element_Abstract $element) {
        $this->setNamePrefix($element->getName())
            ->setHtmlId($element->getHtmlId());

        return $this->_toHtml();
    }

    /**
     * Returns true if this block can provide values.
     *
     * @return boolean
     */
    public function hasValues() {
        return Mage::helper("Crossroads_Klarna/invoice")->hasConfig();
    }

    /**
     * Returns a list of Klarna PClasses or a string with an error message if something went wrong
     *
     * @return Array<PClass>|string
     */
    public function getValues() {
        try {
            return Mage::helper("Crossroads_Klarna/invoice")->fetchPClasses();
        }
        catch(Exception $e) {
            return $e->getMessage();
        }
    }

    public function getIsChecked($id) {
        return in_array($id, $this->getCheckedValues());
    }

    public function getCheckedValues() {
        return array_filter(array_map("trim", explode(",", $this->getConfigData()[Crossroads_Klarna_Helper_Data::CONFIG_PATH_ENABLED_PCLASSES] ?? "")));
    }
}
