<?php

class Crossroads_Klarna_Helper_Data extends Mage_Core_Helper_Abstract
{
    const QUOTE_FIELD_SSN = "socialSecurityNumber";

    const CONFIG_PATH_ENABLED_PCLASSES = "payment/Crossroads_Klarna_Invoice/enabled_pclasses";
    const CONFIG_PATH_MIN_ORDER_TOTAL  = "payment/Crossroads_Klarna_Invoice/min_order_total";

    const FIELD_RESERVATION_ID     = "klarna_reservation_id";
    const FIELD_INVOICE_ID         = "klarna_invoice_id";
    const FIELD_RESERVATION_STATUS = "klarna_reservation_status";
    const FIELD_EID                = "klarna_eid";
    const FIELD_SSN                = "klarna_ssn";
    const FIELD_PCLASS             = "klarna_selected_pclass";

    public function registerPayment(Varien_Event_Observer $observer) {
        $observer->getRegistry()->addMethod(new Crossroads_Klarna_Model_Payment_Invoice());
    }

    /**
     * Validate the social security number if we use our own payment method.
     */
    public function checkoutPostVerifyQuote(Varien_Event_Observer $observer) {
        $quote    = $observer->getQuote();
        $response = $observer->getResponse();
        $enabled  = $this->getEnabledMethods($quote);

        if($quote->getPayment()->getMethod() !== "Crossroads_Klarna_Invoice") {
            return;
        }

        if( ! $quote->getPayment()->getAdditionalInformation(self::FIELD_SSN)) {
            $response->setCode(400);
            $response->setErrorCode(11001);
            $response->setMessage("Missing required paymentMethodData.socialSecurityNumber");

            return;
        }

        if( ! filter_var($quote->getPayment()->getAdditionalInformation(self::FIELD_PCLASS), FILTER_VALIDATE_INT)) {
            $response->setCode(400);
            $response->setErrorCode(11002);
            $response->setMessage("Missing or malformed required paymentMethodData.klarnaPclass, integer required");

            return;
        }

        if( ! in_array($quote->getPayment()->getAdditionalInformation(self::FIELD_PCLASS), $enabled)) {
            $response->setCode(400);
            $response->setErrorCode(11003);
            $response->setMessage("The chosen klarnaPclass is not enabled.");

            return;
        }
    }

    public function getEnabledMethods($quote = null) {
        return array_filter(array_map("trim", explode(",", Mage::getStoreConfig(self::CONFIG_PATH_ENABLED_PCLASSES, $quote ? $quote->getStoreId() : null))));
    }
}
