<?php

use \Klarna\XMLRPC\Exception\KlarnaException;

class Crossroads_Klarna_Controller_Payment extends Crossroads_API_Controller_Super {
    /**
     * @api {get} /payment/Crossroads_Klarna_Invoice/addresses
     * @apiName paymentCrossroads_Klarna_Invoice_getAddresses
     * @apiGroup Klarna
     *
     * @apiParam {string} invId  The inhabitant id for the buyer
     *
     * @apiSuccess {String}   prefix
     * @apiSuccess {String}   firstname
     * @apiSuccess {String}   middlename
     * @apiSuccess {String}   lastname
     * @apiSuccess {String}   suffix
     * @apiSuccess {String}   company
     * @apiSuccess {String[]} street
     * @apiSuccess {String}   postcode
     * @apiSuccess {String}   city
     * @apiSuccess {String}   regionId
     * @apiSuccess {String}   countryId (SE, NO, DK)
     * @apiSuccess {String}   telephone
     * @apiSuccess {String}   fax
     * @apiSuccess {String}   email
     */
    public function addressesAction() {
        if($this->getRequest()->getMethod() !== "GET") {
            return $this->sendData([405]);
        }

        $id = $this->getRequest()->getParam("invId");

        if(!$id) {
            return $this->sendData(self::formatError(400, "Missing query parameter invId"));
        }

        $locale   = Mage::app()->getLocale()->getLocaleCode();
        $currency = Mage::app()->getStore()->getConfig("currency/options/base");

        try {
            $data = Mage::helper("Crossroads_Klarna/invoice")->fetchAddresses($locale, $currency, $id);

            return $this->sendData([200, $data]);
        }
        catch(Exception $e) {
            return $this->handleException($e);
        }
    }
}
