<?php

class Crossroads_Klarna_Block_Info_Invoice extends Mage_Payment_Block_Info {
    protected function _prepareSpecificInformation($transport = null) {
        if($this->_paymentSpecificInformation) {
            return $this->_paymentSpecificInformation;
        }

        $helper  = Mage::helper("Crossroads_Klarna");
        $payment = $this->getInfo();

        $transport = new Varien_Object();
        $transport = parent::_prepareSpecificInformation($transport);

        if(Mage::getDesign()->getArea() === "adminhtml") {
            $transport->addData([
                $helper->__("Reservation #")      => $payment->getAdditionalInformation(Crossroads_Klarna_Helper_Data::FIELD_RESERVATION_ID),
                $helper->__("Reservation status") => $payment->getAdditionalInformation(Crossroads_Klarna_Helper_Data::FIELD_RESERVATION_STATUS),
                $helper->__("EID")                => $payment->getAdditionalInformation(Crossroads_Klarna_Helper_Data::FIELD_EID),
                $helper->__("Invoice #")          => $payment->getAdditionalInformation(Crossroads_Klarna_Helper_Data::FIELD_INVOICE_ID) ?: "–"
            ]);
        }

        return $transport;
    }
}
