# Unofficial Klarna administration module

A module for Klarna administration interface and helper-functions.

## Requirements

* [Composer](https://getcomposer.org/download/)
* [Crossroads-API](http://groot.crossroads.se/modules/Crossroads-API) (Optional‚ provides a way to use this module as checkout)

## Composer.json

Add the following to your `composer.json`:

```
{
	"name": "Your project name",
	"description": "Your project description",
	"require": {
		"klarna-unofficial": "dev-master",
		"magento-hackathon/magento-composer-installer": "*"
	},
	"repositories": [
		{
			"type": "vcs",
			"url":  "git@groot.crossroads.se:modules/Klarna-Unofficial.git"
		}
	],
	"extra": {
		"magento-root-dir":      ".",
		"auto-append-gitignore": true
	}
}
```

## API

This module introduces the following to the `Crossroads-API` module:

* `/api/payment/Crossroads_Klarna_Invoice/addresses?invId=12345678-1234`

  This endpoint yields a list of addresses fetched from Klarna for the given person

* `/api/checkout` will add the key `paymentMethodData` when `Crossroads_Klarna_Invoice` is selected
  containing the following information:

   * `paymentMethods` contains the different payment variants for Klarna, read-only, see https://developers.klarna.com/en/se/kpm/invoice-part-payment/1-prepare-your-checkout

   * `klarnaPclass` is the selected payment variant, writeable, use `pclass_id` from `payment_methods`

   * `socialSecurityNumber` is the personal number of the customer or their date of birth if from AT/DE/NL

   * `error` if any error has happened while communicating with the Klarna API
   
## Checkout flow

1. `PUT /checkout` with `paymentMethod: Crossroads_Klarna_Invoice` and maybe attempt to preselect a `paymentMethodData.klarnaPclass`. Validation is performed with the query-parameter-flag `verify=true` on `PUT /checkout`, or when `POST /checkout` is called. Validating early is not necessary.

2. Present the pclasses for the user from `paymentMethodData.paymentMethods`, if the user is allowed to select any specific payment method using klarna.

3. Present a personal-number field for the user (only Sweden, AT/DE/NL should instead use date of birth).

4. Call `/api/payment/Crossroads_Klarna_Invoice/addresses?invId=` with the personal number (Only Sweden). This returns a list of addresses, including emails.

5. Let the user choose one of the addresses, autofill the *shippingAddress* using these values. Preferably do not allow the user to edit them after selecting. Use the `email` from the address and fill the `email` field too.

6. Normal checkout.

## Development

When this module is installed in a project Composer clones the git reposiotry into `vendor/Klarna-Unofficial`. It will then create hard-links according to the `extra.map` specification inside of `composer.json` of the `Klarna-Unofficial` package.

To modify and develop the `Klarna-Unofficial` module, modify files inside of `vendor/Klarna-Unofficial` instead of `app/code/local/Crossroads/Klarna`. Then commit and push like normal inside of `vendor/Klarna-Unofficial`.