<?php

namespace Fixtures;

use function array_merge;
use function explode;
use function implode;
use function sprintf;
use function trim;

use Mage_Core_Helper_Abstract;
use Mage;
use Exception;

class ImageHelper extends Mage_Core_Helper_Abstract {
    /**
     * Resizes an icon and caches the resulting file. Returns the URL to the resized file.
     *
     * @param  string
     * @return string
     */
    public function resizeIcon($mediaFile) {
        try {
            return $this->resize($mediaFile, 64);
        }
        catch(Exception $e) {
            Mage::logException($e);

            return null;
        }
    }

    public function resizeDescriptionIcon($mediaFile) {
        // TODO: Configurable
        return $this->resize($mediaFile, 256);
    }

    public function resize($mediaFile, $maxSize) {
        $folder   = sprintf("%d_%d", $maxSize, $maxSize);
        $config   = Mage::getSingleton("improvedattributevalues/media_config");
        $origFile = $config->getMediaPath($mediaFile);
        $path     = array_merge(["cache", Mage::app()->getStore()->getId(), $folder], explode("/", trim($mediaFile, "/")));
        $newFile  = implode(DS, array_merge([$config->getBaseMediaPath()], $path));
        $newUrl   = implode("/", array_merge([$config->getBaseMediaUrl()], $path));

        return $newUrl;
    }
}

