<?php

/**
 * @psalm-scope-this Mage_Core_Model_Resource_Setup
 */
$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$table = $conn->newTable($installer->getTable("improvedattributevalues/option_label"))
    ->addColumn("label_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "identity"       => true,
        "auto_increment" => true,
        "unsigned"       => true,
        "nullable"       => false,
        "primary"        => true,
    ])
    ->addColumn("option_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "unsigned" => true,
        "nullable" => false,
    ])
    ->addColumn("store_id", Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
        "unsigned" => true,
        "nullable" => false,
        "default"  => "0",
    ])
    ->addColumn("title", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable" => false,
    ])
    ->addColumn("media", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable" => true,
    ])
    ->addColumn("created_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        "nullable" => false,
        "default"  => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
    ])
    ->addColumn("updated_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        "nullable" => false,
        "default"  => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
    ])
    ->addForeignKey(
        $installer->getFkName(
            "improvedattributevalues/option_label",
            "store_id",
            "core/store",
            "store_id"
        ),
        "store_id", $installer->getTable("core/store"), "store_id",
        Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE)
    ->addForeignKey(
        $installer->getFkName(
            "improvedattributevalues/option_label",
            "option_id",
            "eav/attribute_option",
            "option_id"
        ),
        "option_id", $installer->getTable("eav/attribute_option"), "option_id",
        Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE)
    ->addIndex(
        $installer->getIdxName("improvedattributevalues/option_label", ["option_id", "store_id"], Varien_Db_Adapter_Interface::INDEX_TYPE_UNIQUE),
        [ "option_id", "store_id" ],
        [ "type" => Varien_Db_Adapter_Interface::INDEX_TYPE_UNIQUE ]
    );
$table->setOption("type", "InnoDB");
$table->setOption("charset", "utf8");

$conn->createTable($table);

$table = $conn->newTable($installer->getTable("improvedattributevalues/option_description"))
    ->addColumn("description_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "identity"       => true,
        "auto_increment" => true,
        "unsigned"       => true,
        "nullable"       => false,
        "primary"        => true,
    ])
    ->addColumn("option_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "unsigned" => true,
        "nullable" => false,
    ])
    ->addColumn("store_id", Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
        "unsigned" => true,
        "nullable" => false,
        "default"  => "0",
    ])
    ->addColumn("description", Varien_Db_Ddl_Table::TYPE_TEXT, null, [
        "nullable" => false,
    ])
    ->addColumn("media", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable" => true,
    ])
    ->addColumn("created_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        "nullable" => false,
        "default"  => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
    ])
    ->addColumn("updated_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        "nullable" => false,
        "default"  => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
    ])
    ->addForeignKey(
        $installer->getFkName(
            "improvedattributevalues/option_description",
            "store_id",
            "core/store",
            "store_id"
        ),
        "store_id", $installer->getTable("core/store"), "store_id",
        Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE)
    ->addForeignKey(
        $installer->getFkName(
            "improvedattributevalues/option_description",
            "option_id",
            "eav/attribute_option",
            "option_id"
        ),
        "option_id", $installer->getTable("eav/attribute_option"), "option_id",
        Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE)
    ->addIndex(
        $installer->getIdxName("improvedattributevalues/option_description", ["option_id", "store_id"], Varien_Db_Adapter_Interface::INDEX_TYPE_UNIQUE),
        [ "option_id", "store_id" ],
        [ "type" => Varien_Db_Adapter_Interface::INDEX_TYPE_UNIQUE ]
    );
$table->setOption("type", "InnoDB");
$table->setOption("charset", "utf8");

$conn->createTable($table);

$installer->endSetup();
