<?php

class Crossroads_ImprovedAttributeValues_Helper_Image extends Mage_Core_Helper_Abstract {
    /**
     * Resizes an icon and caches the resulting file. Returns the URL to the resized file.
     *
     * @param  string
     * @return ?string
     */
    public function resizeIcon($mediaFile) {
        try {
            return $this->resize($mediaFile, 64);
        }
        catch(Exception $e) {
            Mage::logException($e);

            return null;
        }
    }

    public function resizeDescriptionIcon($mediaFile) {
        // TODO: Configurable
        try {
            return $this->resize($mediaFile, 256);
        }
        catch(Exception $e) {
            Mage::logException($e);

            return null;
        }
    }

    public function resize($mediaFile, $maxSize) {
        $folder   = sprintf("%d_%d", $maxSize, $maxSize);
        $config   = Mage::getSingleton("improvedattributevalues/media_config");
        $origFile = $config->getMediaPath($mediaFile);
        $path     = array_merge(["cache", Mage::app()->getStore()->getId(), $folder], explode("/", trim($mediaFile, "/")));
        $newFile  = implode(DS, array_merge([$config->getBaseMediaPath()], $path));
        $newUrl   = implode("/", array_merge([$config->getBaseMediaUrl()], $path));

        if( ! file_exists($newFile)) {
            $img = new Varien_Image($origFile);

            $img->constrainOnly(true);
            $img->keepAspectRatio(true);
            $img->keepTransparency(true);
            $img->resize($maxSize, $maxSize);

            $quality = Mage::helper("improvedattributevalues")->getImgQualityConfig();
            if ( ! empty($quality)) {
                $img->quality((int)$quality);
            }

            $img->save($newFile);
        }

        return $newUrl;
    }
}

