<?php

class Crossroads_ImprovedAttributeValues_Helper_Data extends Mage_Core_Helper_Abstract {
    const CONFIG_IMG_QUALITY = "crossroads/improvedattributevalues/image/quality";

    public function getIavLabelsTab() {
        $attributeType = Mage::registry("entity_attribute") ? Mage::registry("entity_attribute")->getFrontendInput() : "default";

        switch($attributeType) {
        case "select":
        case "multiselect":
            $blockName ='improvedattributevalues_adminhtml/catalog_product_attribute_edit_tab_listlabels';
            $layout = Mage::app()->getLayout();
            $block = $layout->createBlock($blockName);

            if( ! $block) {
                throw new Exception(sprintf(
                    "%s: Failed to create block '%s'",
                    __METHOD__,
                    $blockName
                ));
            }

            $content = $block->toHtml();

            break;
        default:
            $content = <<<EOF
<div>
<ul class="messages">
    <li class="error-msg">
        <ul>
            <li>{$this->__("Attribute is not a select or multiselect attribute, cannot associate list labels.")}</li>
        </ul>
    </li>
</ul>
</div>
EOF;
        }

        return [
            "label"   => $this->__("List Labels"),
            "title"   => $this->__("List Labels"),
            "after"   => "labels",
            "content" => $content,
        ];
    }

    public function getIavDescriptionsTab() {
        $attributeType = Mage::registry("entity_attribute") ? Mage::registry("entity_attribute")->getFrontendInput() : "default";

        switch($attributeType) {
        case "select":
        case "multiselect":
            $blockName = 'improvedattributevalues_adminhtml/catalog_product_attribute_edit_tab_descriptions';
            $layout = Mage::app()->getLayout();
            $block = $layout->createBlock($blockName);

            if( ! $block) {
                throw new Exception(sprintf(
                    "%s: Failed to create block '%s'",
                    __METHOD__,
                    $blockName
                ));
            }

            $content = $block->toHtml();
            break;
        default:
            $content = <<<EOF
<div>
<ul class="messages">
    <li class="error-msg">
        <ul>
            <li>{$this->__("Attribute is not a select or multiselect attribute, cannot associate descriptions or icons.")}</li>
        </ul>
    </li>
</ul>
</div>
EOF;
        }

        return [
            "label"   => $this->__("Icons & Descriptions"),
            "title"   => $this->__("Icons & Descriptions"),
            "after"   => "labels",
            "content" => $content,
        ];
    }
}
