<?php

class Crossroads_ImprovedAttributeValues_Model_Resource_Option_Description extends Mage_Core_Model_Resource_Db_Abstract {
    protected function _construct() {
        $this->_init("improvedattributevalues/option_description", "description_id");
    }

    public function getProductDescriptions($product, $storeId) {
        $image = Mage::helper("improvedattributevalues/image");
        $cfg   = Mage::getSingleton("improvedattributevalues/media_config");
        $db    = $this->getReadConnection();

        if( ! $db) {
            throw new Exception("Failed to obtain read connection");
        }

        $attrs = array_filter(array_map(function($a) use($product) {
            return [
                "code"   => $a->getAttributeCode(),
                "id"     => $a->getId(),
                "values" => array_filter(array_map("trim", explode(",", $product->getData($a->getAttributeCode()) ?? ""))),
            ];
        }, array_filter($product->getAttributes(), function($a) {
            return in_array($a->getFrontendInput(), ["select", "multiselect"]) && $a->getBackendType() !== "static" && $a->getIsVisibleOnFront();
        })), function($a) { return !empty($a["values"]); });

        if(empty($attrs)) {
            return [];
        }

        $query = $db->select()
            ->from([ "a" => $this->getTable("eav/attribute") ], ["attribute_code", "frontend_input"])
            ->join([ "o" => $this->getTable("eav/attribute_option") ], "o.attribute_id = a.attribute_id", [])
            ->join([ "vg" => $this->getTable("eav/attribute_option_value") ], "vg.option_id = o.option_id AND vg.store_id = 0", [])
            ->joinLeft([ "vs" => $this->getTable("eav/attribute_option_value") ], sprintf("vs.option_id = o.option_id AND vs.store_id = %d", $storeId), [])
            ->join([ "dg" => $this->getTable("improvedattributevalues/option_description") ], "dg.option_id = o.option_id AND dg.store_id = 0", [])
            ->joinLeft([ "ds" => $this->getTable("improvedattributevalues/option_description") ], sprintf("ds.option_id = o.option_id AND ds.store_id = %d", $storeId), [])
            ->columns([
                "value" => $db->getIfNullSql(
                    $db->quoteIdentifier("vs.value"),
                    $db->quoteIdentifier("vg.value")
                ),
                "descriptionid" => $db->getIfNullSql(
                    $db->quoteIdentifier("ds.description_id"),
                    $db->quoteIdentifier("dg.description_id")
                ),
                "description" => $db->getIfNullSql(
                    $db->quoteIdentifier("ds.description"),
                    $db->quoteIdentifier("dg.description")
                ),
                "media" => $db->getIfNullSql(
                    $db->quoteIdentifier("ds.media"),
                    $db->quoteIdentifier("dg.media")
                ),
            ]);

        foreach($attrs as $a) {
            $query->orWhere(sprintf("a.attribute_id = %d AND o.option_id IN (?)", $a["id"]), $a["values"]);
        }

        $data = [];

        foreach($db->query($query)->fetchAll() as $a) {
            $val = [
                "title"       => $a["value"],
                "description" => $a["description"],
                "icon"        => $a["media"] ? $image->resizeDescriptionIcon($a["media"]) : null,
                "original"    => $cfg->getMediaUrl($a["media"]) ?: null,
            ];

            if($a["frontend_input"] === "multiselect") {
                if( ! array_key_exists($a["attribute_code"], $data)) {
                    $data[$a["attribute_code"]] = [];
                }

                $data[$a["attribute_code"]][] = $val;
            }
            else {
                $data[$a["attribute_code"]] = $val;
            }
        }

        return $data;
    }

    public function getAttributeDescriptions($attribute) {
        if( ! $attribute->getAttributeId()) {
            return [];
        }

        $db = $this->getReadConnection();

        if( ! $db) {
            throw new Exception("Failed to obtain read connection");
        }

        $query = $db->select()
            ->from([ "s" => $this->getTable("core/store") ], ["store_id"])
            ->from([ "eao" => $this->getTable("eav/attribute_option") ], ["option_id"])
            ->join([ "eaov" => $this->getTable("eav/attribute_option_value") ], "eaov.option_id = eao.option_id AND eaov.store_id = 0", [ "store_name" => "value" ])
            ->joinLeft([ "d" => $this->getTable("improvedattributevalues/option_description") ], "s.store_id = d.store_id AND eao.option_id = d.option_id", [ "description_id", "description", "media" ])
            ->where("eao.attribute_id = ?", $attribute->getAttributeId())
            ->order(["eaov.value ASC", "s.store_id ASC"]);

        $stmt = $db->query($query);

        $ret = [];

        foreach($stmt as $row) {
            if( ! array_key_exists($row["option_id"], $ret)) {
                $ret[$row["option_id"]] = [
                    "store_label" => $row["store_name"],
                    "stores"      => [],
                ];
            }

            $ret[$row["option_id"]]["stores"][$row["store_id"]] = [
                "description_id" => $row["description_id"],
                "description"    => $row["description"],
                "media"          => $row["media"],
            ];
        }

        return $ret;
    }

    public function attributeSaveAfter($event) {
        $db           = Mage::getSingleton('core/resource')->getConnection("core_write");
        $dataObject   = $event->getDataObject();
        $options      = $dataObject->getOption();
        $ids          = $dataObject->getIavDescriptionIds();
        $descriptions = $dataObject->getIavDescriptions();
        $icons        = $dataObject->getIavDescriptionMedia();
        $toInsert     = [];
        $toDelete     = [];

        if( ! $db) {
            throw new Exception("Failed to obtain write connection");
        }

        foreach($descriptions ?: [] as $optionId => $desc) {
            if( ! array_key_exists($optionId, $options["value"]) || ! empty($options["delete"][$optionId])) {
                continue;
            }

            foreach($desc as $storeId => $d) {
                if( ! empty($ids[$optionId][$storeId])) {
                    if(empty($d) && empty($icons[$optionId][$storeId])) {
                        $toDelete[] = $ids[$optionId][$storeId];

                        continue;
                    }

                    $db->update($this->getTable("improvedattributevalues/option_description"), [
                        "option_id"   => $optionId,
                        "store_id"    => $storeId,
                        "description" => $d,
                        "media"       => empty($icons[$optionId][$storeId]) ? null : $this->unTmpImage($icons[$optionId][$storeId]),
                        "updated_at"  => new Zend_Db_Expr("NOW()"),
                    ], [
                        "description_id = ?" => $ids[$optionId][$storeId],
                    ]);
                }
                else if( ! empty($d) || ! empty($icons[$optionId][$storeId])) {
                    $toInsert[] = [
                        "option_id"   => $optionId,
                        "store_id"    => $storeId,
                        "description" => $d,
                        "media"       => empty($icons[$optionId][$storeId]) ? null : $this->unTmpImage($icons[$optionId][$storeId]),
                    ];
                }
            }
        }

        if( ! empty($toInsert)) {
            $db->insertMultiple($this->getTable("improvedattributevalues/option_description"), $toInsert);
        }

        if( ! empty($toDelete)) {
            $db->delete($this->getTable("improvedattributevalues/option_description"), ["description_id IN (?)" => $toDelete]);
        }
    }

    public function unTmpImage($file) {
        if(strlen(trim($file ?? "")) === 0) {
            return null;
        }

        $config = Mage::getSingleton("improvedattributevalues/media_config");

        if( ! file_exists($config->getTmpMediaPath($file))) {
            // Nothing to do, file should be uploaded
            return $file;
        }

        $ioObject      = new Varien_Io_File();
        $destDirectory = dirname($config->getMediaPath($file));

        try {
            $ioObject->open(array('path'=>$destDirectory));
        } catch (Exception $e) {
            $ioObject->mkdir($destDirectory, 0777, true);
            $ioObject->open(array('path'=>$destDirectory));
        }

        if (strrpos($file, '.tmp') == strlen($file)-4) {
            $file = substr($file, 0, strlen($file)-4);
        }

        $destFile = $this->_getUniqueFileName($file, $ioObject->dirsep());
        $storageHelper = Mage::helper('core/file_storage_database');

        if ($storageHelper->checkDbUsage()) {
            $storageHelper->renameFile($config->getTmpMediaShortUrl($file), $config->getMediaShortUrl($destFile));

            $ioObject->rm($config->getTmpMediaPath($file));
            $ioObject->rm($config->getMediaPath($destFile));
        } else {
            $ioObject->mv($config->getTmpMediaPath($file), $config->getMediaPath($destFile));
        }

        return str_replace($ioObject->dirsep(), '/', $destFile);
    }

    /**
     * Check whether file to move exists. Getting unique name
     */
    protected function _getUniqueFileName(string $file, string $dirsep): string {
        if(Mage::helper("core/file_storage_database")->checkDbUsage()) {
            return Mage::helper("core/file_storage_database")->getUniqueFilename(
                Mage::getSingleton("catalog/product_media_config")->getBaseMediaUrlAddition(),
                $file
            );
        }

        return dirname($file) . $dirsep . Mage_Core_Model_File_Uploader::getNewFileName(
            Mage::getSingleton("improvedattributevalues/media_config")->getMediaPath($file)
        );
    }
}

