<?php

class Crossroads_ImprovedAttributeValues_Model_Indexer_Option_Label extends Mage_Index_Model_Indexer_Abstract {
    const UPDATE_KEY = "Crossroads_ImprovedAttributeValues_update_attribute_id";

    protected $_matchedEntities = [
        Mage_Catalog_Model_Resource_Eav_Attribute::ENTITY => [
            Mage_Index_Model_Event::TYPE_SAVE,
            // Not needed since we have cascades:
            // Mage_Index_Model_Event::TYPE_DELETE,
        ],
    ];

    public function getName() {
        return "ImprovedAttributeValues";
    }

    public function getDescription() {
        return "Index process for indexing label images for product lists";
    }

    protected function _registerEvent(Mage_Index_Model_Event $event) {
        $dataObject = $event->getDataObject();

        switch($event->getEntity()) {
        case Mage_Catalog_Model_Resource_Eav_Attribute::ENTITY:
            $event->addNewData(self::UPDATE_KEY, $dataObject->getEntityId());
            break;
        }
    }

    public function _processEvent(Mage_Index_Model_Event $event) {
        $dataObject = $event->getNewData();
        $resource   = Mage::getResourceModel("improvedattributevalues/option_label");

        if( ! empty($dataObject[self::UPDATE_KEY])) {
            $resource->updateAttributeLabels([$dataObject[self::UPDATE_KEY]]);
        }
    }

    public function reindexAll() {
        Mage::getResourceModel("improvedattributevalues/option_label")->reindexAll();
    }
}
